/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class JLogCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    JLogGraph parent;
    private int last_x;
    private int last_y;
    private float zoom_xmin;
    private float zoom_xmax;
    private float zoom_ymin;
    private float zoom_ymax;
    private int invalid = -99999;
    private int last_gr = -1;
    private boolean zoom;
    private boolean dragging;

    public JLogCanvas(JLogGraph jLogGraph) {
        this.parent = jLogGraph;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.last_x = mouseEvent.getX();
        this.last_y = mouseEvent.getY();
        if (this.zoom) {
            this.repaint();
            return;
        }
        if (!this.dragging) {
            this.zoom_xmin = mouseEvent.getX();
            this.zoom_ymin = mouseEvent.getY();
            this.dragging = true;
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.zoom) {
            this.repaint();
            return;
        }
        if (this.dragging) {
            this.zoom_xmax = mouseEvent.getX();
            this.zoom_ymax = mouseEvent.getY();
            this.dragging = false;
            this.zoom = true;
        }
        this.last_x = mouseEvent.getX();
        this.last_y = mouseEvent.getY();
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.last_x = mouseEvent.getX();
        this.last_y = mouseEvent.getY();
        if (mouseEvent.getX() < 10 && mouseEvent.getY() < 10) {
            this.zoom = false;
            this.dragging = false;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        float f;
        float f2;
        float f3;
        float f4;
        int n3;
        float f5 = 99999.0f;
        float f6 = -99999.0f;
        float f7 = 99999.0f;
        float f8 = -99999.0f;
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        int n6 = 2 * n4 / 10;
        int n7 = n4 / 2;
        int n8 = 8 * n5 / 10;
        int n9 = -7 * n5 / 10;
        int n10 = n7 / 20;
        int n11 = n9 / 20;
        int[] nArray = new int[this.parent.nrows];
        int[] nArray2 = new int[this.parent.nrows];
        Color[] colorArray = new Color[]{Color.red, Color.blue, Color.green, Color.black, Color.magenta, Color.pink, Color.cyan, Color.gray};
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = new Rectangle(n6 - n10, n8 + n9 + n11, n7 + 2 * n10, -n9 - 2 * n11);
        if (this.last_gr == -1) {
            this.last_gr = this.parent.currgr;
        }
        if (this.last_gr != this.parent.currgr) {
            this.zoom = false;
            this.last_gr = this.parent.currgr;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n4, n5);
        graphics.setColor(Color.gray);
        graphics.draw3DRect(0, 0, n4 - 1, n5 - 1, false);
        graphics.setColor(Color.red);
        if (this.dragging) {
            graphics.draw3DRect((int)this.zoom_xmin, (int)this.zoom_ymin, this.last_x - (int)this.zoom_xmin, this.last_y - (int)this.zoom_ymin, false);
        }
        if (this.zoom) {
            graphics.fill3DRect(0, 0, 10, 10, false);
            n3 = fontMetrics.getHeight();
            graphics.drawString("Reset zoom", 15, n3);
        }
        graphics.setColor(Color.black);
        for (int i = 0; i < this.parent.nrows; ++i) {
            f4 = this.parent.data[this.parent.graphCols[this.parent.currgr][0]][i];
            if (Float.isNaN(f4)) continue;
            f5 = Math.min(f5, f4);
            f6 = Math.max(f6, f4);
            for (int j = 1; j < this.parent.graphNCols[this.parent.currgr]; ++j) {
                f3 = this.parent.data[this.parent.graphCols[this.parent.currgr][j]][i];
                if (Float.isNaN(f3)) continue;
                f7 = Math.min(f7, f3);
                f8 = Math.max(f8, f3);
            }
        }
        if (!Float.isNaN(this.parent.graphXmins[this.parent.currgr])) {
            f5 = this.parent.graphXmins[this.parent.currgr];
        }
        if (!Float.isNaN(this.parent.graphXmaxs[this.parent.currgr])) {
            f6 = this.parent.graphXmaxs[this.parent.currgr];
        }
        if (!Float.isNaN(this.parent.graphYmins[this.parent.currgr])) {
            f7 = this.parent.graphYmins[this.parent.currgr];
        }
        if (!Float.isNaN(this.parent.graphYmaxs[this.parent.currgr])) {
            f8 = this.parent.graphYmaxs[this.parent.currgr];
        }
        if (f6 <= f5) {
            f2 = (float)(1.0E-24 + 5.0E-7 * (double)Math.abs(f5 + f6));
            f4 = f6 - f2;
            f3 = f5 + f2;
            f5 = f4;
            f6 = f3;
        }
        if (f8 <= f7) {
            f2 = (float)(1.0E-24 + 5.0E-7 * (double)Math.abs(f7 + f8));
            f4 = f8 - f2;
            f3 = f7 + f2;
            f7 = f4;
            f8 = f3;
        }
        float[] fArray = this.ticks(f5, f6, 4);
        f5 = Math.min(f5, fArray[0]);
        f6 = Math.max(f6, fArray[fArray.length - 1]);
        float[] fArray2 = this.ticks(f7, f8, 4);
        f7 = Math.min(f7, fArray2[0]);
        f8 = Math.max(f8, fArray2[fArray2.length - 1]);
        if (this.zoom && this.zoom_xmin != this.zoom_xmax && this.zoom_ymin != this.zoom_ymax) {
            float f9 = Math.min(this.zoom_xmin, this.zoom_xmax);
            float f10 = Math.max(this.zoom_xmin, this.zoom_xmax);
            this.zoom_xmin = f9;
            this.zoom_xmax = f10;
            f9 = Math.min(this.zoom_ymin, this.zoom_ymax);
            f10 = Math.max(this.zoom_ymin, this.zoom_ymax);
            this.zoom_ymin = f9;
            this.zoom_ymax = f10;
            float f11 = f7;
            float f12 = f8;
            f = f5;
            float f13 = f6;
            f5 = (f13 - f) * (this.zoom_xmin - (float)n6) / (float)n7 + f;
            f6 = (f13 - f) * (this.zoom_xmax - (float)n6) / (float)n7 + f;
            f8 = (f12 - f11) * (this.zoom_ymin - (float)n8) / (float)n9 + f11;
            f7 = (f12 - f11) * (this.zoom_ymax - (float)n8) / (float)n9 + f11;
        } else {
            this.zoom = false;
        }
        n3 = fontMetrics.getHeight();
        boolean bl = false;
        String string = this.parent.colTitles[this.parent.graphCols[this.parent.currgr][0]];
        if (string.indexOf("1/resol^2") >= 0 || string.indexOf("4SSQ/LL") >= 0) {
            bl = true;
            string = "Resolution/A";
        }
        graphics.setColor(Color.red);
        graphics.drawString("Mouse Position", n6 + n7 + 50, n8 - 4 * n3);
        graphics.drawString("(click to update)", n6 + n7 + 50, n8 - 3 * n3);
        if (!this.zoom) {
            graphics.drawString("(drag to zoom)", n6 + n7 + 50, n8 - 2 * n3);
        }
        graphics.setColor(Color.blue);
        f = (f6 - f5) * (float)(this.last_x - n6) / (float)n7 + f5;
        if (bl) {
            f = (float)Math.sqrt(1.0 / Math.max((double)f, 1.0E-4));
            graphics.drawString("r = " + String.valueOf(f), n6 + n7 + 50, n8 - n3);
        } else {
            graphics.drawString("x = " + String.valueOf(f), n6 + n7 + 50, n8 - n3);
        }
        graphics.drawString("y = " + String.valueOf((f8 - f7) * (float)(this.last_y - n8) / (float)n9 + f7), n6 + n7 + 50, n8);
        graphics.setColor(Color.black);
        graphics.drawLine(n6, n8 - n11, n6 + n7, n8 - n11);
        graphics.drawLine(n6 - n10, n8, n6 - n10, n8 + n9);
        for (n2 = 0; n2 < fArray.length; ++n2) {
            f4 = fArray[n2];
            if (bl) {
                f4 = (float)Math.sqrt(1.0 / Math.max((double)f4, 1.0E-4));
            }
            String string2 = this.floatfmt(f4, 6);
            if (bl) {
                string2 = this.floatfmt(f4, 4);
            }
            int n12 = n6 + (int)((float)n7 * (fArray[n2] - f5) / (f6 - f5));
            graphics.drawLine(n12, n8 - n11, n12, n8 - n11 * 4 / 3);
            graphics.drawString(string2, n12, n8 - n11 * 4 / 3 + n3);
        }
        for (n2 = 0; n2 < fArray2.length; ++n2) {
            f3 = fArray2[n2];
            String string3 = this.floatfmt(f3, 8);
            n = fontMetrics.stringWidth(string3);
            int n13 = n8 + (int)((float)n9 * (fArray2[n2] - f7) / (f8 - f7));
            graphics.drawLine(n6 - n10, n13, n6 - n10 * 4 / 3, n13);
            graphics.drawString(string3, n6 - n10 * 4 / 3 - n, n13 + n3 / 3);
        }
        n = fontMetrics.stringWidth(string);
        graphics.drawString(string, n6 + (n7 - n) / 2, n8 - n11 * 4 / 3 + 2 * n3);
        for (n2 = 1; n2 < this.parent.graphNCols[this.parent.currgr]; ++n2) {
            int n14;
            graphics.setColor(colorArray[(n2 - 1) % 8]);
            graphics.drawString(this.parent.colTitles[this.parent.graphCols[this.parent.currgr][n2]], n6 + n7 + n3, n8 + n9 + n2 * n3);
            int n15 = 0;
            for (n14 = 0; n14 < this.parent.nrows; ++n14) {
                f4 = this.parent.data[this.parent.graphCols[this.parent.currgr][0]][n14];
                f3 = this.parent.data[this.parent.graphCols[this.parent.currgr][n2]][n14];
                if (Float.isNaN(f4) || Float.isNaN(f3)) continue;
                nArray[n15] = (int)((float)n6 + (float)n7 * (f4 - f5) / (f6 - f5));
                nArray2[n15] = (int)((float)n8 + (float)n9 * (f3 - f7) / (f8 - f7));
                ++n15;
            }
            graphics.setClip(rectangle2);
            if (this.parent.linewidth == 0) {
                for (n14 = 0; n14 < n15; ++n14) {
                    graphics.fillOval(nArray[n14] - 2, nArray2[n14] - 2, 5, 5);
                }
            } else {
                for (n14 = 1; n14 < n15; ++n14) {
                    graphics.fillOval(nArray[n14] - 1, nArray2[n14] - 1, 3, 3);
                    graphics.drawLine(nArray[n14 - 1], nArray2[n14 - 1], nArray[n14], nArray2[n14]);
                }
            }
            graphics.setClip(rectangle);
        }
    }

    public String floatfmt(float f, int n) {
        int n2;
        String string = String.valueOf(f);
        if (string.length() > n && (n2 = string.indexOf(".")) >= 0 && n2 <= n) {
            string = string.substring(0, n);
        }
        return string;
    }

    public float[] ticks(float f, float f2, int n) {
        double[] dArray = new double[]{1.0, 2.0, 5.0};
        float f3 = f2 - f;
        float f4 = f3 / (float)(n - 1);
        double d = 1.0;
        for (int i = -12; i <= 12; ++i) {
            if (!(Math.pow(10.0, i) * dArray[0] < (double)f4)) continue;
            d = Math.pow(10.0, i);
        }
        double d2 = d * dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d * dArray[i] < (double)f4)) continue;
            d2 = d * dArray[i];
        }
        long l = Math.round((double)f / d2);
        long l2 = Math.round((double)f2 / d2);
        int n2 = (int)(l2 - l + 1L);
        float[] fArray = new float[n2];
        for (int i = 0; i < n2; ++i) {
            fArray[i] = (float)((double)(l + (long)i) * d2);
        }
        return fArray;
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 150);
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }
}

